package com.smart.hospital.common.mq.client;

import com.smart.hospital.common.mq.annotation.Id;
import com.smart.hospital.common.mq.annotation.Exchange;
import com.smart.hospital.common.mq.annotation.Message;
import com.smart.hospital.common.mq.annotation.RoutingKey;

/**
 * 发送消息客户端
 */
public interface RabbitClient {

	/**
	 * 发送消息
	 *
	 * @param exchange        交换机
	 * @param routingKey      路由键
	 * @param msg             消息
	 * @param id 消息的唯一标识
	 */
	void send(@Exchange String exchange, @RoutingKey String routingKey, @Message Object msg, @Id String id);

}
