package com.smart.hospital.common.lock.service.impl.redis;

import com.smart.hospital.common.lock.key.LockKey;
import com.smart.hospital.common.lock.service.AbstractRedisLockService;
import org.redisson.RedissonMultiLock;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

import java.util.List;

public class RedisMultiRedisLockService extends AbstractRedisLockService {

	private RedissonMultiLock lock;

	public RedisMultiRedisLockService(LockKey<String, List<String>> lockKey, RedissonClient client) {
		super(lockKey, client);
	}

	@Override
	public void lock() throws Exception {
		RLock[] lockList = new RLock[lockKey.getKey().size()];
		for (int i = 0; i < lockKey.getKey().size(); i++) {
			lockList[i] = client.getLock(lockKey.getKey().get(i));
		}

		lock = new RedissonMultiLock(lockList);

		if (lockKey.getLeaseTime() == -1 && lockKey.getWaitTime() == -1) {
			lock.lock();
			return;
		}
		if (lockKey.getLeaseTime() != -1 && lockKey.getWaitTime() == -1) {
			lock.lock(lockKey.getLeaseTime(), lockKey.getTimeUnit());
			return;
		}
		if (lockKey.getLeaseTime() != -1 && lockKey.getWaitTime() != -1) {
			boolean isLock = lock.tryLock(lockKey.getWaitTime(), lockKey.getLeaseTime(), lockKey.getTimeUnit());
			if (!isLock) {
				throw new IllegalStateException("加锁失败");
			}
			return;
		}

		lock.lock();
	}

	@Override
	public void release() {
		lock.unlock();
	}
}
