package com.smart.hospital.common.lock.service;

import com.smart.hospital.common.lock.key.LockKey;
import com.smart.hospital.common.lock.service.provider.LockServiceProvider;
import org.apache.curator.framework.CuratorFramework;
import org.redisson.api.RedissonClient;

import java.util.List;

public class LockProviderManager implements LockServiceManager {

	private List<LockServiceProvider> providers;

	private RedissonClient redissonClient;

	private CuratorFramework zkClient;


	public LockProviderManager(List<LockServiceProvider> providers, RedissonClient redissonClient, CuratorFramework zkClient) {
		this.providers = providers;
		this.redissonClient = redissonClient;
		this.zkClient = zkClient;
	}

	@Override
	public LockService findLockService(LockKey<String, List<String>> lockKey) {
		if (providers != null && providers.size() > 0) {
			for (LockServiceProvider provider : getProviders()) {
				if (!provider.supports(lockKey.getLockScheme(), lockKey.getLockType())) {
					continue;
				}
				return provider.getLockService(zkClient, redissonClient, lockKey);
			}
		}
		return null;
	}

	public List<LockServiceProvider> getProviders() {
		return providers;
	}
}
