package com.smart.hospital.common.lock.provider.manager;

import com.smart.hospital.common.lock.config.InitConfig;
import com.smart.hospital.common.lock.provider.pattern.PatternProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.InitializingBean;

import java.util.Collections;
import java.util.List;

/**
 * 管理redis的模式，并进行配置
 */
public class RedisServerPatternManager implements PatternManager, InitializingBean {

	private static final Log logger = LogFactory.getLog(RedisServerPatternManager.class);

	private List<PatternProvider> providers = Collections.emptyList();

	public RedisServerPatternManager(List<PatternProvider> providers) {
		this.providers = providers;
	}

	@Override
	public RedissonClient initConfig(InitConfig baseConfig) {
		for (PatternProvider provider : getProviders()) {
			if (!provider.supports(baseConfig.getPattern())) {
				continue;
			}
			logger.debug("PatternProvider attempt using " + provider.getClass().getName());
			return provider.init(baseConfig);
		}
		throw new IllegalArgumentException("没用合适的创建 RedissonClient 的provider");
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		checkState();
	}

	private void checkState() {
		if (providers == null || providers.isEmpty()) {
			throw new IllegalArgumentException("A list of PatternProviders is required");
		}
	}

	public List<PatternProvider> getProviders() {
		return providers;
	}
}
