package com.smart.hospital.common.lock.key.strategy.impl;


import com.smart.hospital.common.lock.advisor.attribute.LockAttribute;
import com.smart.hospital.common.lock.enums.LockScheme;
import com.smart.hospital.common.lock.key.LockKey;
import com.smart.hospital.common.lock.key.strategy.AbstractKeyStrategy;
import com.smart.hospital.common.lock.key.strategy.KeyStrategy;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;

public class ParameterKeyStrategy extends AbstractKeyStrategy {

	public ParameterKeyStrategy(String className, String methodName, Method realMethod, Object[] args, LockScheme scheme, LockAttribute attribute) {
		super(className, methodName, realMethod, args, scheme, attribute);
	}

	@Override
	protected void buildKeyItem(LockKey<String, List<String>> lockKey) {
		Parameter[] parameters = realMethod.getParameters();
		if(parameters != null && parameters.length > 0){
			for (int i = 0; i < parameters.length; i++) {
				if (parameters[i].isAnnotationPresent(KeyStrategy.KEY_ANNOTATION_CLASS)) {
					lockKey.setKey(wrapKey(args[i].toString()));
				}
			}
		}
	}
}
