package com.smart.hospital.common.lock.config;

import com.smart.hospital.common.lock.config.redis.RedisClusterConfig;
import com.smart.hospital.common.lock.config.redis.RedisSingleConfig;
import com.smart.hospital.common.lock.constant.LockCommonConstant;

/**
 * redis配置
 */
public class RedisSchemeConfig {

	/**
	 * 单机模式配置
	 */
	private RedisSingleConfig singleServer;

	/**
	 * redis集群配置
	 */
	private RedisClusterConfig clusterServer;

	/**
	 * 客户端名称
	 */
	private String clientName = LockCommonConstant.LOCK_CLIENT_NAME;

	/**
	 * 启动SSL终端识别
	 */
	private Boolean sslEnable = Boolean.TRUE;

	/**
	 * SSL实现方式，确定采用哪种方式(JDK或OPENSSL)来实现SSL连接
	 */
	private String sslProvider = LockCommonConstant.JDK;
	;

	/**
	 * SSL正式路径
	 */
	private String sslCertPath;

	/**
	 * SSL信任证书库密码
	 */
	private String sslCertPassword;

	/**
	 * SSL钥匙库路径
	 */
	private String sslKeyPath;

	/**
	 * SSL钥匙库密码
	 */
	private String sslKeyPassword;

	/*getter and setter*/

	public RedisSingleConfig getSingleServer() {
		return singleServer;
	}

	public void setSingleServer(RedisSingleConfig singleServer) {
		this.singleServer = singleServer;
	}

	public RedisClusterConfig getClusterServer() {
		return clusterServer;
	}

	public void setClusterServer(RedisClusterConfig clusterServer) {
		this.clusterServer = clusterServer;
	}

	public String getClientName() {
		return clientName;
	}

	public void setClientName(String clientName) {
		this.clientName = clientName;
	}

	public Boolean getSslEnable() {
		return sslEnable;
	}

	public void setSslEnable(Boolean sslEnable) {
		this.sslEnable = sslEnable;
	}

	public String getSslProvider() {
		return sslProvider;
	}

	public void setSslProvider(String sslProvider) {
		this.sslProvider = sslProvider;
	}

	public String getSslCertPath() {
		return sslCertPath;
	}

	public void setSslCertPath(String sslCertPath) {
		this.sslCertPath = sslCertPath;
	}

	public String getSslCertPassword() {
		return sslCertPassword;
	}

	public void setSslCertPassword(String sslCertPassword) {
		this.sslCertPassword = sslCertPassword;
	}

	public String getSslKeyPath() {
		return sslKeyPath;
	}

	public void setSslKeyPath(String sslKeyPath) {
		this.sslKeyPath = sslKeyPath;
	}

	public String getSslKeyPassword() {
		return sslKeyPassword;
	}

	public void setSslKeyPassword(String sslKeyPassword) {
		this.sslKeyPassword = sslKeyPassword;
	}

}
