package com.smart.hospital.common.lock.advisor.source;

import com.smart.hospital.common.lock.advisor.attribute.LockAttribute;
import com.smart.hospital.common.lock.key.LockKey;

import java.lang.reflect.Method;
import java.util.List;

public interface LockAttributeSource {

	/**
	 * 从方法或者类上面通过反射获取注解信息
	 * 在拦截器（拦截方法获取注解信息）和切点（判断是否创建切面代理）解析的时候会用到
	 *
	 * @param method
	 * @param targetClass
	 * @return
	 */
	LockAttribute getLockAttribute(Method method, Class<?> targetClass);

	/**
	 * 从方法上的注解@Key
	 *
	 * @param method
	 * @param targetClass
	 * @param arguments
	 * @return
	 */
	LockKey<String, List<String>> getLockKey(Method method, Class<?> targetClass, Object[] arguments, LockAttribute attr);
}
