package com.smart.hospital.common.lock.advisor.source;

import com.smart.hospital.common.lock.advisor.attribute.LockAttribute;
import com.smart.hospital.common.lock.advisor.parser.DistributedLockAnnotationParser;
import com.smart.hospital.common.lock.advisor.parser.LockAnnotationParser;
import com.smart.hospital.common.lock.key.LockKey;
import com.smart.hospital.common.lock.key.strategy.KeyStrategy;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * 注解解析资源
 */
public class AnnotationDistributedLockAttributeSource extends AbstractDistributedLockAttributeSource {

	/**
	 * 只允许解析public修饰的方法
	 */
	private final boolean publicMethodsOnly;

	/**
	 * 委托的注解解析器
	 */
	private final Set<LockAnnotationParser> annotationParsers;

	public AnnotationDistributedLockAttributeSource() {
		this(true);
	}

	public AnnotationDistributedLockAttributeSource(boolean publicMethodsOnly) {
		this.publicMethodsOnly = publicMethodsOnly;
		this.annotationParsers = Collections.singleton(new DistributedLockAnnotationParser());
	}

	@Override
	protected LockAttribute findLockAttribute(Method method) {
		return determineLockAttribute(method);
	}

	@Override
	protected LockAttribute findLockAttribute(Class<?> clazz) {
		return determineLockAttribute(clazz);
	}

	protected LockAttribute determineLockAttribute(AnnotatedElement element) {
		for (LockAnnotationParser parser : this.annotationParsers) {
			LockAttribute attr = parser.parseLockAnnotation(element);
			if (attr != null) {
				return attr;
			}
		}
		return null;
	}

	@Override
	protected LockKey<String, List<String>> findLockKey(Method method, Class<?> targetClass, Object[] arguments, LockAttribute attr) {
		KeyStrategy strategy = null;
		for (LockAnnotationParser parser : this.annotationParsers) {
			strategy = parser.parseKeyAnnotation(method, targetClass, arguments, attr);
			if (strategy != null) {
				break;
			}
		}
		if (strategy != null) {
			return strategy.buildKey();

		}
		return null;
	}

	@Override
	protected boolean allowPublicMethodOnly() {
		return this.publicMethodsOnly;
	}

	@Override
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (!(other instanceof AnnotationDistributedLockAttributeSource)) {
			return false;
		}
		AnnotationDistributedLockAttributeSource otherTas = (AnnotationDistributedLockAttributeSource) other;
		return (this.annotationParsers.equals(otherTas.annotationParsers) &&
				this.publicMethodsOnly == otherTas.publicMethodsOnly);
	}

	@Override
	public int hashCode() {
		return Objects.hash(annotationParsers);
	}
}
