package com.smart.hospital.common.lock.advisor.intercept;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;

/**
 * 分布式锁增强器
 */
public class LockInterceptor extends LockInterceptorSupport implements MethodInterceptor {

	@Override
	public Object invoke(MethodInvocation invocation) throws Throwable {
		Class<?> targetClass = invocation.getThis() != null ? AopUtils.getTargetClass(invocation.getThis()) : null;
		return invocationWithLock(invocation.getMethod(), targetClass, invocation.getArguments(), invocation::proceed);
	}
}
