package com.smart.hospital.common.lock.advisor.attribute;

import com.smart.hospital.common.lock.enums.LockType;

import java.util.concurrent.TimeUnit;

public class DistributedLockAttribute implements LockAttribute {

	/**
	 * 锁类型
	 */
	private LockType lockType;

	/**
	 * 加锁时间，超过该时长自动解锁，默认单位为：秒
	 */
	private long leaseTime;

	/**
	 * 等待锁时间，默认单位：秒
	 */
	private long waitTime;

	/**
	 * 锁时长单位
	 */
	private TimeUnit timeUnit;

	@Override
	public LockType getLockType() {
		return lockType;
	}

	public void setLockType(LockType lockType) {
		this.lockType = lockType;
	}

	@Override
	public long getLeaseTime() {
		return leaseTime;
	}

	public void setLeaseTime(long leaseTime) {
		this.leaseTime = leaseTime;
	}

	@Override
	public long getWaitTime() {
		return waitTime;
	}

	public void setWaitTime(long waitTime) {
		this.waitTime = waitTime;
	}

	@Override
	public TimeUnit getTimeUnit() {
		return timeUnit;
	}

	public void setTimeUnit(TimeUnit timeUnit) {
		this.timeUnit = timeUnit;
	}

	@Override
	public String toString() {
		return "DistributedLockAttribute{" +
				"lockType=" + lockType +
				", leaseTime=" + leaseTime +
				", waitTime=" + waitTime +
				", timeUnit=" + timeUnit +
				'}';
	}
}
