package com.smart.hospital.common.lock.advisor;

import com.smart.hospital.common.lock.advisor.intercept.LockInterceptor;
import com.smart.hospital.common.lock.advisor.source.AnnotationDistributedLockAttributeSource;
import com.smart.hospital.common.lock.advisor.source.LockAttributeSource;
import com.smart.hospital.common.lock.custom.InterceptorCustomizer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 创建锁切面自动配置类
 */
@Configuration
public class LockInterceptorAutoConfiguration {

	private final List<InterceptorCustomizer> customizers;

	public LockInterceptorAutoConfiguration(ObjectProvider<List<InterceptorCustomizer>> customizers) {
		this.customizers = customizers.getIfAvailable();
	}

	/**
	 * 创建锁的切面
	 *
	 * @return
	 */
	@Bean
	public DistributedLockAdvisor distributedLockAdvisor() {
		DistributedLockAdvisor advisor = new DistributedLockAdvisor();
		advisor.setLockAttributeSource(lockAttributeSource());
		advisor.setAdvice(lockInterceptor());
		return advisor;
	}

	/**
	 * 注解信息解析
	 *
	 * @return
	 */
	@Bean
	public LockAttributeSource lockAttributeSource() {
		return new AnnotationDistributedLockAttributeSource();
	}

	/**
	 * 具体的切面逻辑
	 *
	 * @return
	 */
	@Bean
	public LockInterceptor lockInterceptor() {
		LockInterceptor interceptor = new LockInterceptor();
		interceptor.setLockAttributeSource(lockAttributeSource());
		applyLockInterceptor(interceptor);
		return interceptor;
	}

	public void applyLockInterceptor(LockInterceptor interceptor) {
		if (!CollectionUtils.isEmpty(this.customizers)) {
			for (InterceptorCustomizer customizer : customizers) {
				customizer.customize(interceptor);
			}
		}
	}
}
