package org.liquibase.core.liquibase;

import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;

import java.util.HashMap;
import java.util.Map;


public class LiquibaseStartupListener implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {

    @Override
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        MutablePropertySources propertySources = environment.getPropertySources();
        // set liquibase env
        Map<String, Object> propertyMap = new HashMap<>();
        propertyMap.put("spring.liquibase.enabled", false);
        propertyMap.put("spring.liquibase.dynamic.config.change-log", "classpath:migration/changelog-master.xml");
        propertyMap.put("spring.liquibase.dynamic.config.databaseChangeLogTable", "MG_LIQUIBASE_LOG");
        propertyMap.put("spring.liquibase.dynamic.config.databaseChangeLogLockTable", "MG_LIQUIBASE_LOCK");
        propertyMap.put("spring.liquibase.dynamic.config.clearChecksums", true);
        propertySources.addFirst(new MapPropertySource("default_liquibase_env_property", propertyMap));
    }
}
