package org.liquibase.core.property;

import java.util.Objects;

public abstract class DynamicProperty<T> {

    /**
     * 获取属性名称
     *
     * @return
     */
    public abstract String getName();

    /**
     * 获取属性值
     *
     * @return
     */
    public abstract T getValue();

    /**
     * 数据库管理系统
     *
     * @return
     */
    public String getDbms() {
        return null;
    }

    @Override
    public String toString() {
        Object value = getValue();
        Objects.requireNonNull(value, "value must not be null");
        return value.toString();
    }

}
