"""
@Project ：chatwoot-agent 
@File    ：settings.py
@Author  ：Lijun
@Date    ：2025/8/19 10:36 
"""
import logging
import os

from dotenv import load_dotenv


class Config:
    # 加载配置
    load_dotenv()
    # redis配置
    REDIS_HOST = os.getenv("REDIS_HOST", "10.10.31.26")
    print(f"redis的连接地址为:{REDIS_HOST}")
    REDIS_PORT = int(os.getenv("REDIS_PORT", 6379))
    REDIS_DB = int(os.getenv("REDIS_DB", 2))
    REDIS_PASSWORD = os.getenv("REDIS_PASSWORD", None)
    REDIS_CACHE_TTL = os.getenv("REDIS_CACHE_TTL", 300)  # 默认5分钟

    # 环境配置
    APP_ENV = os.getenv("APP_ENV", "development")
    FLASK_PORT = int(os.getenv("FLASK_PORT", 4000))

    # chatwoot配置
    CHATWOOT_BOT_TOKEN = os.getenv("CHATWOOT_BOT_TOKEN")
    CHATWOOT_URL = os.getenv("CHATWOOT_URL")

    # ragflow配置
    RAGFLOW_AGENT_AUTHORIZATION = os.getenv("RAGFLOW_AGENT_AUTHORIZATION")
    RAGFLOW_AGENT_URL = os.getenv("RAGFLOW_AGENT_URL")
    RAGFLOW_AGENT_ID = os.getenv("RAGFLOW_AGENT_ID")

    # 日志配置
    LOG_LEVEL = logging.INFO
    LOG_DIR = 'logs'

    if not os.path.exists(LOG_DIR):
        os.makedirs(LOG_DIR)

    # 日志文件路径
    APP_LOG_FILE = os.path.join(LOG_DIR, 'app.log')
    ERROR_LOG_FILE = os.path.join(LOG_DIR, 'error.log')
    ACCESS_LOG_FILE = os.path.join(LOG_DIR, 'access.log')

    # 日志格式
    LOG_FORMAT = '%(asctime)s - %(name)s - %(levelname)s - %(filename)s:%(lineno)d - %(message)s'


class ProductionConfig(Config):
    # 生产环境1小时
    REDIS_CACHE_TTL = 3600
    LOG_LEVEL = logging.INFO


class DevelopmentConfig(Config):
    DEBUG = True
    LOG_LEVEL = logging.DEBUG


config_dict = {
    "production": ProductionConfig,
    "development": DevelopmentConfig
}
