"""
@Project ：chatwoot-agent 
@File    ：services.py
@Author  ：Lijun
@Date    ：2025/8/19 14:17 
"""
from typing import List

from redis import Redis

from cache import redis_cache
from config.logger import get_logger

logger = get_logger(__name__)


class CacheService:

    @staticmethod
    def set(cache_key: str, data: str, ttl: int = None):
        try:
            redis_client = redis_cache.get_client()
            if ttl is None:
                redis_client.set(cache_key, data)
            else:
                redis_client.setex(cache_key, ttl, data)
        except Exception as e:
            logger.error(f"Cache set error: {str(e)}")

    @staticmethod
    def get(cache_key: str):
        try:
            redis_client: Redis = redis_cache.get_client()
            return redis_client.get(cache_key)
        except Exception:
            logger.error(f"未获取到key:{cache_key}的值.")
            return None

    @staticmethod
    def lrange(cache_key: str, start: int, end: int) -> List:
        try:
            redis_client = redis_cache.get_client()
            return redis_client.lrange(cache_key, start, end)
        except Exception:
            logger.error(f"未获取到key:{cache_key}的值.")
            return []

    @staticmethod
    def invalidate(cache_key: str):
        redis_client: Redis = redis_cache.get_client()
        try:
            logger.info(f"删除历史对话的session_id: {cache_key}")
            redis_client.delete(cache_key)
        except Exception as e:
            logger.error(f'Cache invalidation error: {str(e)}')
