"""
@Project ：chatwoot-agent 
@File    ：__init__.py.py
@Author  ：Lijun
@Date    ：2025/8/19 9:46 
"""
from redis import Redis, RedisError


class RedisCache:
    def __init__(self, app=None):
        self.app = app
        self.redis_client = None
        if app is not None:
            self.init_app(app)

    def init_app(self, app):
        """初始化连接redis"""
        try:
            self.redis_client = Redis(
                host=app.config["REDIS_HOST"],
                port=int(app.config["REDIS_PORT"]),
                db=app.config['REDIS_DB'],
                password=app.config['REDIS_PASSWORD'],
                decode_responses=True,
                socket_timeout=5,
                socket_connect_timeout=5
            )
            # 测试连接
            self.redis_client.ping()
            app.logger.info('Redis cache connected successfully')
        except RedisError as e:
            app.logger.error(f"Failed to connect to Redis: {str(e)}")
            raise

    def get_client(self):
        if not self.redis_client:
            raise RuntimeError("Redis cache not initialized")
        return self.redis_client


# 初始化扩展实例
redis_cache = RedisCache()
