"""
@Project ：chatwoot-agent 
@File    ：chatwoot_app.py
@Author  ：Lijun
@Date    ：2025/8/19 11:22 
"""
from functools import wraps
from typing import Optional

from flask import (
    request as flask_request, jsonify
)

from config.logger import get_logger
from model.chatwoot_model import MessageEvent
from service.chatwoot_service import ChatwootConversationService

logger = get_logger(__name__)


def validate_request():
    def wrapper(func):
        @wraps(func)
        def decorated_function():
            json_data = flask_request.json
            logger.info(f"请求参数:{json_data}")
            message_event = MessageEvent(**json_data)
            return func(message_event)

        return decorated_function

    return wrapper


@manager.route('', methods=['POST'])
@validate_request()
def chatwoot_agent(message_event: Optional[MessageEvent]):
    ChatwootConversationService.handle_conversation(message_event)
    return jsonify({"status": "success"}), 200
