import json
from datetime import datetime
from typing import Optional, Dict, List, Any
from pydantic import BaseModel, Field


# 基础模型
class Account(BaseModel):
    id: int
    name: str


class Inbox(BaseModel):
    id: int
    name: str


class Sender(BaseModel):
    id: int
    name: Optional[str] = Field(default=None)
    type: Optional[str] = Field(default=None)
    avatar_url: Optional[str] = Field(default=None)


class ContactInbox(BaseModel):
    id: int
    contact_id: int
    inbox_id: int
    source_id: str
    created_at: datetime
    updated_at: datetime
    hmac_verified: bool
    pubsub_token: str


class BrowserInfo(BaseModel):
    device_name: str
    browser_name: str
    platform_name: str
    browser_version: str
    platform_version: str


class InitiatedAt(BaseModel):
    timestamp: str


class AdditionalAttributes(BaseModel):
    browser: Optional[BrowserInfo] = None
    referer: Optional[Any] = None
    initiated_at: Optional[InitiatedAt] = None
    browser_language: Optional[str] = None


class MessageConversation(BaseModel):
    assignee_id: Optional[int] = None
    unread_count: int
    last_activity_at: int
    contact_inbox: Dict[str, str]


class MessageSender(BaseModel):
    id: int
    name: Optional[str] = Field(default=None)
    avatar_url: Optional[str] = Field(default=None)
    type: Optional[str] = Field(default=None)


class Message(BaseModel):
    id: int
    content: Optional[str] = Field(default=False)
    account_id: int
    inbox_id: int
    conversation_id: int
    message_type: int = None
    created_at: int
    updated_at: datetime
    private: Optional[bool] = Field(default=False)
    status: Optional[str] = Field(default=False)
    source_id: Optional[str] = Field(default=False)
    content_type: Optional[str] = Field(default=False)
    content_attributes: Dict[str, Any] = Field(default=False)
    sender_type: Optional[str] = Field(default=False)
    sender_id: Optional[int] = Field(default=None)
    external_source_ids: Dict[str, Any]
    additional_attributes: Dict[str, Any]
    processed_message_content: Optional[str] = Field(default=None)
    sentiment: Dict[str, Any]
    conversation: Optional[MessageConversation] = Field(default=None)
    sender: Optional[MessageSender] = Field(default=None)


class MetaSender(BaseModel):
    additional_attributes: Dict[str, Any]
    custom_attributes: Dict[str, Any]
    email: Optional[str] = Field(default=None)
    id: int
    identifier: Optional[str] = Field(default=None)
    name: Optional[str] = Field(default=None)
    phone_number: Optional[str] = Field(default=None)
    thumbnail: Optional[str] = Field(default=None)
    blocked: Optional[bool] = Field(default=False)
    type: Optional[str] = Field(default=None)


class Meta(BaseModel):
    sender: Optional[MetaSender] = Field(default=None)
    assignee: Optional[Any] = None
    team: Optional[Any] = None
    hmac_verified: bool


class Conversation(BaseModel):
    additional_attributes: AdditionalAttributes = Field(default=None)
    can_reply: bool
    channel: str
    contact_inbox: Optional[ContactInbox] = Field(default=None)
    id: int
    inbox_id: int
    messages: Optional[List[Message]] = Field(default=[])
    labels: List[Any]
    meta: Optional[Meta] = Field(default=None)
    status: str
    custom_attributes: Dict[str, Any]
    snoozed_until: Optional[Any] = None
    unread_count: int
    first_reply_created_at: Optional[Any] = None
    priority: Optional[Any] = None
    waiting_since: int
    agent_last_seen_at: int
    contact_last_seen_at: int
    last_activity_at: int
    timestamp: int
    created_at: int
    updated_at: float


# 主模型
class MessageEvent(BaseModel):
    account: Optional[Account] = Field(default=None)
    additional_attributes: Dict[str, Any] = Field(default=None)
    content_attributes: Dict[str, Any] = Field(default=None)
    content_type: Optional[str] = Field(default=None)
    content: Optional[str] = Field(default=None)
    conversation: Optional[Conversation] = Field(default=None)
    created_at: Optional[datetime] = Field(default=None)
    id: int
    inbox: Optional[Inbox] = Field(default=None)
    message_type: Optional[str] = None
    private: Optional[bool] = Field(default=False)
    sender: Optional[Sender] = Field(default=None)
    source_id: Optional[str] = Field(default=None)
    event: str
    contact_inbox: Optional[ContactInbox] = Field(default=None)
