"""
@Project ：chatwoot-agent 
@File    ：base_api.py
@Author  ：Lijun
@Date    ：2025/8/29 16:19 
"""
import requests

from cache.services import CacheService
from config.logger import get_logger
from config.settings import Config

logger = get_logger(__name__)


def remove_null_bytes(data):
    if isinstance(data, dict):
        return {k: remove_null_bytes(v) for k, v in data.items()}
    elif isinstance(data, list):
        return [remove_null_bytes(item) for item in data]
    elif isinstance(data, str):
        return data.replace('\x00', '')
    else:
        return data


def create_new_message(account_id, conversation_id, message):
    data = {
        'content': remove_null_bytes(message)
    }
    url = f"{Config.CHATWOOT_URL}/api/v1/accounts/{account_id}/conversations/{conversation_id}/messages"
    headers = {"Content-Type": "application/json",
               "Accept": "application/json",
               "api_access_token": f"{Config.CHATWOOT_BOT_TOKEN}"}

    r = requests.post(url, json=data, headers=headers)
    return r.json()


def toggle_status(account_id, conversation_id, status):
    data = {
        'status': status
    }
    url = f"{Config.CHATWOOT_URL}/api/v1/accounts/{account_id}/conversations/{conversation_id}/toggle_status"
    headers = {"Content-Type": "application/json",
               "Accept": "application/json",
               "api_access_token": f"{Config.CHATWOOT_BOT_TOKEN}"}
    r = requests.post(url, json=data, headers=headers)
    return r.json()


def ragflow_agent(sender_id: int, msg: str):
    try:
        agent_url = f"{Config.RAGFLOW_AGENT_URL}/api/v1/agentbots/{Config.RAGFLOW_AGENT_ID}/completions"
        # 从redis获取session_id
        session_id = CacheService.get(f"c:cr:{sender_id}")

        agent_data = {
            "question": msg,
            "stream": 0,
            "session_id": session_id
        }

        headers = {
            "Content-Type": "application/json",
            "Accept": "application/json",
            "Authorization": f"Bearer {Config.RAGFLOW_AGENT_AUTHORIZATION}"
        }
        agent_res = requests.post(agent_url, json=agent_data, headers=headers)
        json_res = agent_res.json()
        code = json_res.get("code")
        if code != 0:
            raise ValueError
        answer = json_res["data"]["answer"]
        session_id = json_res["data"]["session_id"]
        if session_id is not None:
            CacheService.set(f"c:cr:{sender_id}", session_id)
        return answer
    except Exception as e:
        logger.info(f"请求ragflow出现故障:{e}")
        return "智能系统出现故障,转入人工客服."
