import { ref } from 'vue';

const selectedToolCall = ref(null);

function setSelectedToolCall(toolCall) {
    selectedToolCall.value = toolCall;
}

function clearSelectedToolCall() {
    selectedToolCall.value = null;
}

export default function useToolCallStore() {
    return {
        selectedToolCall,
        setSelectedToolCall,
        clearSelectedToolCall,
    };
}
