from redis import Redis
from agent.llm.llm import AsyncQwen3Agent
from agent.llm.prompt import AGENT_PROMPT
from agent.memory.memory import RedisMemory
from agent.tools.tools import tool_manager, ToolManager, register_medical_tools,register_tools

API_KEY = "your_api_key"
# BASE_URL = "http://180.163.119.106:16031/v1"
BASE_URL = "http://180.163.119.106:16015/v1"
MODEL_NAME = "Fusion2-chat-v2.0"
#

#
# # #
# API_KEY = "sk-ba458ddd9fd649ea9442cc0461b496c6"
# BASE_URL = "https://dashscope.aliyuncs.com/compatible-mode/v1"
# # MODEL_NAME = "qwen3-235b-a22b"  # 或者 qwen3模型名称
# MODEL_NAME = "qwen3-30b-a3b"  # 或者 qwen3模型名称

# Redis 客户端建议复用，不用每次都重新创建
redis_client = Redis(host="localhost", port=6379, password="21221", decode_responses=True)


def create_agent(session_id: str) -> AsyncQwen3Agent:
    CONFIG = {
        # "FastGPT": {
        #     "url": "https://cloud.fastgpt.cn/api/mcp/app/oj7BgLJmYh45J17YxC7EEFAj/mcp"
        # },
        # "filesystem": {
        #     "args": [
        #         "-y",
        #         "@modelcontextprotocol/server-filesystem",
        #         "/tmp"
        #     ],
        #     "command": "npx"
        # }
        # "redis": {
        #     "command": "npx",
        #     "args": [
        #         "-y",
        #         "@modelcontextprotocol/server-redis",
        #         "redis://:21221@localhost:6379/1"
        #     ]
        # }
    }

    tool_manager = ToolManager(CONFIG)
    # register_medical_tools(tool_manager)
    register_tools(tool_manager)

    memory = RedisMemory(session_id=session_id, agent_id="weather", redis_client=redis_client)
    agent = AsyncQwen3Agent(
        api_key=API_KEY,
        base_url=BASE_URL,
        model_name=MODEL_NAME,
        tool_manager=tool_manager,
        memory=memory,
        sys_prompt=AGENT_PROMPT,
        # sys_prompt='/nothink'
    )
    return agent


import asyncio


async def main(session_id: str):
    user_input = "查下病人张三的信息？并且查下上海的天气"
    agent = create_agent(session_id)

    await agent.tool_manager.initialize()

    async for event in agent.stream(user_input=user_input):
        if event["type"] == "content":
            print(event["text"], end="", flush=True)
        elif event["type"] == "think_start":
            print("\n【模型思考开始】", end="", flush=True)
        elif event["type"] == "think_continue":
            print(event["text"], end="", flush=True)
        elif event["type"] == "think_end":
            print(event["text"], flush=True)
            print("【模型思考结束】")
        elif event["type"] == "tool_calls":
            tool_info = event["info"]
            print(f"\n【触发工具调用】函数：{tool_info}")

            async for followup in agent.stream(tool_calls=tool_info):
                if followup["type"] == "content":
                    print(followup["text"], end="", flush=True)
                elif followup["type"] == "done":
                    print("\n【对话完成】")
                    return
        elif event["type"] == "done":
            print("\n【对话完成】")
            return


if __name__ == "__main__":
    asyncio.run(main("session423"))
