import asyncio
from mcp.client.streamable_http import streamablehttp_client
from mcp import ClientSession


async def main():
    try:
        # 连接到 streamable HTTP 服务端
        async with streamablehttp_client("https://cloud.fastgpt.cn/api/mcp/app/og8ghYLRVsFMLi8GZ2nTFALn/mcp") as (
            read_stream,
            write_stream,
            _
        ):
            # 创建客户端会话
            async with ClientSession(read_stream, write_stream) as session:
                # 初始化连接
                await session.initialize()
                list = await session.list_tools()
                print(list)
                #
                # # 调用工具（如 echo 工具）
                # tool_result = await session.call_tool("echo", {"message": "hello"})
                #
                # print("Tool result:", tool_result)

    except asyncio.CancelledError:
        print("任务被取消")
    except Exception as e:
        print("发生错误:", e)


if __name__ == "__main__":
    asyncio.run(main())
