import asyncio
import logging

from agent.tools.mcp.base import BaseMcpClient,create_mcp_client

# 配置日志
logging.basicConfig(level=logging.INFO)


# 示例配置：包含 HTTP 和 Stdio 客户端
CONFIG = {
    "mcpServers": {
        "FastGPT-mcp-6825886b058310fae2e58a3d": {
            "url": "https://cloud.fastgpt.cn/api/mcp/app/og8ghYLRVsFMLi8GZ2nTFALn/mcp"
        },
        # "filesystem": {
        #     "command": "npx",
        #     "args": [
        #         "-y",
        #         "@modelcontextprotocol/server-filesystem",
        #         "C:\\Users\\byshe\\Desktop",
        #     ]
        # },
        # "FusionAI-mcp-d92407ae-ab04-4bce-991c-e1a603e5fe67": {
        #     "url": "http://192.168.120.59:4000/api/mcp_service/d92407ae-ab04-4bce-991c-e1a603e5fe67/mcp/"
        # }
    }
}

async def run():
    clients: list[BaseMcpClient] = []

    try:
        # 初始化所有 MCP 客户端
        for name, conf in CONFIG["mcpServers"].items():
            client = create_mcp_client(name, conf)
            await client.initialize()
            logging.info(f"[{name}] Initialized.")
            clients.append(client)

        # 遍历客户端调用工具列表
        for client in clients:
            tools = await client.list_tools()
            print(f"\n[{client.name}] 可用工具列表:")
            for tool in tools:
                print(f"- {tool}")

            # # 示例：调用第一个工具（如果有）
            # if tools:
            #     tool_name = tools[0].get("tool_name") if isinstance(tools[0], dict) else tools[0]
            #     result = await client.call_tool(tool_name, arguments={"query": "hello"})
            #     print(f"[{client.name}] 调用工具 {tool_name} 返回结果:\n{result}")

    except Exception as e:
        logging.error(f"运行中发生错误: {e}")

    finally:
        pass
        # # 清理所有客户端资源
        # for client in clients:
        #     await client.cleanup()
        #     logging.info(f"[{client.name}] 已清理资源.")


if __name__ == "__main__":
    import logging

    logging.getLogger("httpx").setLevel(logging.WARNING)
    asyncio.run(run())

